procedure ConvFont(nfont         : integer;
                   var CharReMap : CharReMapArr;
                   var FParam    : FontParamRec;
                   var FDim      : FontDimenRec;
                   var FChar     : CharDataType;
                   var FLig      : ptrLigRecord;
                   var FLigB     : ptrLigRecord);
var ptrC, ptrCH : ptrCharReMap;
    ptrL, ptrLH, pLH : ptrLigRecord;
    i, j, k : integer;
    res : float;
    ich : byte;
    fl : boolean;
begin

     for i:=0 to 255 do CharReMap[i]:=nil;

     if FParam.FontDesignUnits <= 0.0 then
     begin
          ErrorLog('*** Error : DESIGNUNITS < 0 : '
                      +ConvReal(FParam.FontDesignUnits));
          ErrorLog('            DESIGNUNITS is set to 1.0');
          FParam.FontDesignUnits:=1.0;
     end;
     if FParam.FontDesignSize <= 0.0 then
     begin
          ErrorLog('*** Error : DESIGNSIZE < 0 : '
                      +ConvReal(FParam.FontDesignSize));
          ErrorLog('            DESIGNSIZE is set to 10.0');
          FParam.FontDesignSize:=10.0;
     end;
     res:=(FParam.FontDesignSize*VParamGlb.FontDesignUnits)
         /(FParam.FontDesignUnits*VParamGlb.FontDesignSize);
     if FontsParm^[nfont].FlFontAt then
     begin
          res:=res*FontsParm^[nfont].FontAT/FParam.FontDesignSize;
     end;

     for i:=0 to 255 do
     with FChar[i] do
     begin
          if defined then
          begin
              CharWD:=CharWD*res;
              CharHT:=CharHT*res;
              CharDP:=CharDP*res;
              CharIC:=CharIC*res;
          end;
     end;

     ptrL:=FLig;
     while ptrL <> nil do
     begin
          if ptrL^.TTLig = TKern
             then ptrL^.KernValue:=res*ptrL^.KernValue;
          ptrL:=ptrL^.ptrNext;
     end; {while}

     ptrL:=FLigB;
     with ptrL^ do
     begin
          if ptrL^.TTLig = TKern
             then ptrL^.KernValue:=res*ptrL^.KernValue;
          ptrL:=ptrL^.ptrNext;
     end; {while}

     {---- Prepare list of coding ------}
     for i:=0 to 255 do
     with CharDataGlb^[i] do
     if FlTFMData or (marked = CharUsed)
        or ((marked = CharDVI) and (DefMapfont or DefMapchar))
     then begin
          if FlTFMData then
          begin
               k:=sizefont; j:=sizechar;
          end
          else begin
               k:=mapfont; j:=mapchar;
          end;
          if (nfont = k) then
          begin
               if not FChar[j].defined then
               begin
                    ErrorLog('*** Error : Character '+ConvChar(i)+' is mapped to character '+ConvChar(j));
                    ErrorLog('               in font D '+ConvInt(k)+' which does not contain');
                    ErrorLog('               this character. Character '+ConvChar(i)+' is discarded.');
                    marked:=CharDiscard; FlagError:=true;
               end
               else begin
                    new(ptrC); ptrC^.ptrNext:=nil;
                    ptrC^.charmap:=i; ptrC^.dummy:=0;
                    ptrCH:=CharReMap[j];
                    if ptrCH = nil then CharReMap[j]:=ptrC
                       else begin
                            while ptrCH^.ptrNext <> nil
                                  do ptrCH:=ptrCH^.ptrNext;
                            ptrCH^.ptrNext:=ptrC;
                       end;
               end;
          end; {if nfont = ...}
     end; {for i}
     {---- end : prepare list of coding ------}

     {---- Re-map Main LigTable ---}
     ptrL:=FLig;
     while ptrL <> nil do
     with ptrL^ do
     begin
          if marked in [LigUsed, LigUsedBound] then
          case TTLig of
          TLabel : if CharReMap[LigChar] = nil then
          begin
               ErrorLog('*** Error : No prototypes for character '
                         +ConvChar(LigChar)+' from font D '+ConvInt(nfont));
               ErrorLog('            LIGTABLE record [LABEL] is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end
          else begin
               ptrC:=CharReMap[LigChar];
               LigChar:=ptrC^.charmap;

               ptrC:=ptrC^.ptrNext;
               while ptrC <> nil do
               begin
                     new(ptrLH); ptrLH^:=ptrL^;
                     ptrLH^.LigChar:=ptrC^.charmap;
                     ptrLH^.marked:=LigAdded;
                     ptrL^.ptrNext:=ptrLH;
                     ptrC:=ptrC^.ptrNext;
               end; {while}

          end; {TLabel}

          TLabelBoundary : {??????}
          begin
               ErrorLog('*** Error : LABEL BOUNDARYCHAR is illegal here');
               ErrorLog('            LIGTABLE record is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end;

          TKern : if marked = LigUsedBound then
          begin
               KernChar:=BoundCharGlb;
          end
          else if CharReMap[KernChar] = nil then
          begin
               ErrorLog('*** Error : No prototypes for character '
                         +ConvChar(KernChar)+' from font D '+ConvInt(nfont));
               ErrorLog('            LIGTABLE record [KRN] is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end
          else begin

               if (FParam.FlBoundChar) and (FParam.BoundChar = KernChar)
               then begin
                    KernChar:=BoundCharGlb;
                    marked:=LigUsedBound;
                    ptrC:=CharReMap[KernChar];
               end
               else begin
                    ptrC:=CharReMap[KernChar];
                    KernChar:=ptrC^.charmap;
                    ptrC:=ptrC^.ptrNext;
               end;

               while ptrC <> nil do
               begin
                     new(ptrLH); ptrLH^:=ptrL^;
                     ptrLH^.KernChar:=ptrC^.charmap;
                     ptrLH^.marked:=LigAdded;
                     ptrL^.ptrNext:=ptrLH;
                     ptrC:=ptrC^.ptrNext;
               end; {while}

          end; {TKern}

          TStop : ;

          TSkip : ;

          TLig, TSLig, TSLigH, TLigS,
          TLigSH, TSLigS, TSLigSH,
          TSLigSHH : if CharReMap[InsChar] = nil then
          begin
               ErrorLog('*** Error : No prototypes for character '
                         +ConvChar(InsChar)+' from font D '+ConvInt(nfont));
               ErrorLog('            LIGTABLE record [LIG] is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end
          else if marked = LigUsedBound then
          begin
               NextChar:=BoundCharGlb;
               InsChar:=CharReMap[InsChar]^.charmap;
          end
          else if CharReMap[NextChar] = nil then
          begin
               ErrorLog('*** Error : No prototypes for character '
                         +ConvChar(NextChar)+' from font D '+ConvInt(nfont));
               ErrorLog('            LIGTABLE record [LIG] is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end
          else begin
            ptrC:=CharReMap[InsChar];
            InsChar:=ptrC^.charmap;

            if (FParam.FlBoundChar) and (FParam.BoundChar = NextChar)
            then begin
                 NextChar:=BoundCharGlb;
                 marked:=LigUsedBound;
                 ptrC:=CharReMap[NextChar];
            end
            else begin
                 ptrC:=CharReMap[NextChar];
                 NextChar:=ptrC^.charmap;
                 ptrC:=ptrC^.ptrNext;
            end;

            while ptrC <> nil do
            begin
                  new(ptrLH); ptrLH^:=ptrL^;
                  ptrLH^.NextChar:=ptrC^.charmap;
                  ptrLH^.marked:=LigAdded;
                  ptrL^.ptrNext:=ptrLH;
                  ptrC:=ptrC^.ptrNext;
            end; {while}
          end; {TLIG}

          end; {case}

          ptrL:=ptrL^.ptrNext;

     end; {while}
     {---- end : re-map Main LigTable ---}

     {---- Re-map Bound LigTable ---}
     ptrL:=FLigB;
     while ptrL <> nil do
     with ptrL^ do
     begin
          if marked in [LigUsed, LigUsedBound] then
          case TTLig of
          TLabel :
          begin
               ErrorLog('*** Error : LABEL is illegal here');
               ErrorLog('            LIGTABLE record is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end;

          TLabelBoundary :
          begin
               ErrorLog('*** Error : LABEL BOUNDARYCHAR is illegal here');
               ErrorLog('            LIGTABLE record is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end;

          TKern : if marked = LigUsedBound then
          begin
               KernChar:=BoundCharGlb;
          end
          else if CharReMap[KernChar] = nil then
          begin
               ErrorLog('*** Error : No prototypes for character '
                         +ConvChar(KernChar)+' from font D '+ConvInt(nfont));
               ErrorLog('            LIGTABLE record [KRN] is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end
          else begin

               if (FParam.FlBoundChar) and (FParam.BoundChar = KernChar)
               then begin
                    KernChar:=BoundCharGlb;
                    marked:=LigUsedBound;
                    ptrC:=CharReMap[KernChar];
               end
               else begin
                    ptrC:=CharReMap[KernChar];
                    KernChar:=ptrC^.charmap;
                    ptrC:=ptrC^.ptrNext;
               end;

               while ptrC <> nil do
               begin
                     new(ptrLH); ptrLH^:=ptrL^;
                     ptrLH^.KernChar:=ptrC^.charmap;
                     ptrLH^.marked:=LigAdded;
                     ptrL^.ptrNext:=ptrLH;
                     ptrC:=ptrC^.ptrNext;
               end; {while}

          end; {TKern}

          TStop :
          begin
               ErrorLog('*** Error : STOP is illegal here');
               ErrorLog('            LIGTABLE record is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end;

          TSkip :
          begin
               ErrorLog('*** Error : SKIP is illegal here');
               ErrorLog('            LIGTABLE record is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end;

          TLig, TSLig, TSLigH, TLigS,
          TLigSH, TSLigS, TSLigSH,
          TSLigSHH : if CharReMap[InsChar] = nil then
          begin
               ErrorLog('*** Error : No prototypes for character '
                         +ConvChar(InsChar)+' from font D '+ConvInt(nfont));
               ErrorLog('            LIGTABLE record [LIG] is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end
          else if marked = LigUsedBound then
          begin
               NextChar:=BoundCharGlb;
               InsChar:=CharReMap[InsChar]^.charmap;
          end
          else if CharReMap[NextChar] = nil then
          begin
               ErrorLog('*** Error : No prototypes for character '
                         +ConvChar(NextChar)+' from font D '+ConvInt(nfont));
               ErrorLog('            LIGTABLE record [LIG] is discarded.');
               marked:=LigNotUsed; FlagError:=true;
          end
          else begin
            ptrC:=CharReMap[InsChar];
            InsChar:=ptrC^.charmap;

            if (FParam.FlBoundChar) and (FParam.BoundChar = NextChar)
            then begin
                 NextChar:=BoundCharGlb;
                 marked:=LigUsedBound;
                 ptrC:=CharReMap[NextChar];
            end
            else begin
                 ptrC:=CharReMap[NextChar];
                 NextChar:=ptrC^.charmap;
                 ptrC:=ptrC^.ptrNext;
            end;

            while ptrC <> nil do
            begin
                  new(ptrLH); ptrLH^:=ptrL^;
                  ptrLH^.NextChar:=ptrC^.charmap;
                  ptrLH^.marked:=LigAdded;
                  ptrL^.ptrNext:=ptrLH;
                  ptrC:=ptrC^.ptrNext;
            end; {while}

          end; {TLIG}

          end; {case}

          ptrL:=ptrL^.ptrNext;

     end; {while}
     {---- end : re-map Bound LigTable ---}

     {---- Update SKIP's for Main LigTable ---}
     UpdateSkipRecord(FLig);

end; {ConvFont}

