procedure LoadFontFile(ss : string;
                       var FParam : FontParamRec;
                       var FDim   : FontDimenRec;
                       var FChar  : CharDataType;
                       var FLig   : ptrLigRecord);

var FLigEnd, FLigNew : ptrLigRecord;
var UChar  : CharUsedArr;
var HFlags : FontHeadFlags;
var i      : integer;
var sh, s  : string;
    sbuf   : string;
var NBuf   : integer;
    Buf    : BufRecord;
    Ident  : string;
    RState : ReadState;
    icn    : integer;
    ichar  : byte;
    fl     : boolean;
begin

    for i:=0 to 256 do UChar[i]:=false;

    FLig:=nil;

    sh:=UpCaseString(ss);
    if sh = 'EMPTY' then exit;
    if sh = 'DUMMY' then
    begin
         for i:=0 to 255 do FChar[i].defined:=true;
         exit;
    end;

    sh:=FindFileLoc(ss,'.PL');
    if sh = '' then
    begin
         ErrorLog('*** Unable to open file : '+ss);
         FlagError:=true; FlagSevere:=true;
         exit;
    end
    else begin
         ErrorLog('File '+sh+' is used to load FONT data');
    end;

    StartRead(sh);

    while not EndOfRead do
    begin
         RState:=NoCommRead(IDent,NBuf,Buf);
         case RState of
         OpenBrace,
         CloseBrace : begin

            if IDent = 'CHECKSUM' then
            begin
            {--------- CHECKSUM --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 FParam.FontCheckSum:=ConvFromLongInt(sbuf,true);
            {--------- end CHECKSUM --------------------}
            end
            else if IDent = 'DESIGNSIZE' then
            begin
            {--------- DESIGNSIZE --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 FParam.FontDesignSize:=ConvFromReal(sbuf,true);
            {--------- end DESIGNSIZE --------------------}
            end
            else if IDent = 'DESIGNUNITS' then
            begin
            {--------- DESIGNUNITS --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 FParam.FontDesignUnits:=ConvFromReal(sbuf,true);
            {--------- end DESIGNUNITS --------------------}
            end
            else if IDent = 'CODINGSCHEME' then
            begin
            {--------- CODINGSCHEME --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 FParam.FontCoding:=DelSpaces(PackBuf(NBuf,Buf));
            {--------- end CODINGSCHEME --------------------}
            end
            else if IDent = 'FAMILY' then
            begin
            {--------- FAMILY --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 FParam.FontFamily:=DelSpaces(PackBuf(NBuf,Buf));
            {--------- end FAMILY --------------------}
            end
            else if IDent = 'FACE' then
            begin
            {--------- FACE --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 sbuf:=PackBuf(NBuf,Buf);
                 FParam.FontFace:=ConvFromByte(sbuf,true);
            {--------- end FACE --------------------}
            end
            else if IDent = 'SEVENBITSAFEFLAG' then
            begin
            {--------- SEVENBITSAFEFLAG --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 ErrorLog('*** Warning : SEVENBITSAFEFLAG is ignored');
                 LogReadState;
            {--------- end SEVENBITSAFEFLAG --------------------}
            end
            else if IDent = 'HEADER' then
            begin
            {--------- HEADER --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 ErrorLog('*** Warning : HEADER is ignored');
                 LogReadState;
            {--------- end HEADER --------------------}
            end
            else if (IDent = 'BOUNDARYCHAR') or (IDent = 'BCHAR') then
            begin
            {--------- BOUNDARYCHAR --------------------}
                 if RState <> CloseBrace then FileFix11(IDent);
                 if FParam.FlBoundChar then
                 begin
                      ErrorLog('*** Warning : BOUNDARYCHAR is re-defined');
                      LogReadState;
                 end;
                 sbuf:=PackBuf(NBuf,Buf);
                 FParam.BoundChar:=ConvFromByte(sbuf,true);
                 FParam.FlBoundChar:=true;
            {--------- end BOUNDARYCHAR --------------------}
            end
            else if IDent = 'FONTDIMEN' then
            begin
            {--------- FONTDIMEN --------------------}
                 LoadFDimStruct(false, FDim, HFlags,
			 RState, IDent, NBuf, Buf);
            {--------- end FONTDIMEN --------------------}
            end
            else if IDent = 'LIGTABLE' then
            begin
            {--------- LigTable ---------------------}
                 LoadLigStruct(FLigNew, FLigEnd,
			 RState, IDent, NBuf, Buf);
            {--------- end LIGTABLE --------------------}
                if FLigNew <> nil then
                begin
                     CheckLig(FLigNew,UChar);
                     if FLig <> nil then
                     begin
                        FLigEnd:=FLig;
                        while FLigEnd^.ptrNext <> nil
                           do FLigEnd:=FLigEnd^.ptrNext;
                        FLigEnd^.ptrNext:=FLigNew;
                     end
                     else FLig:=FLigNew;
                end;
            {-------- end LigTable ---------------------}
            end
            else if (IDent = 'CHARACTER') or (IDent = 'CHAR') then
            begin
            {--------- CHARACTER --------------------}
                if NBuf <= 0 then
                begin
                     ErrorLog('*** Error : CHARACTER without parameter');
                     LogReadState; FlagError:=true;
                end;
                sbuf:=PackBuf(NBuf,Buf);
                ichar:=ConvFromByte(sbuf,true);

                if RState = OpenBrace then icn:=1
                else begin
                     icn:=0;
                     ErrorLog('*** Warning : CHARACTER without list parameters');
                     LogReadState;
                end;
                if FChar[ichar].defined then
                begin
                     ErrorLog('*** Warning : CHARACTER '+ConvChar(ichar)
                                +' was defined already');
                     LogReadState;
                end
                else FChar[ichar].defined:=true;

                while (icn > 0) do
                begin
                     RState:=NoCommRead(IDent,NBuf,Buf);
                     case RState of
                     OpenBrace : begin
                         icn:=icn+1;
                         if (icn <> 2) or (IDent <> 'VARCHAR')
                         then begin
                             ErrorLog('*** Error : CHARACTER cannot have list parameters other than VARCHAR.');
                             ErrorLog('            Parameter '+IDent+' is ignored');
                             LogReadState; FlagError:=true;
                         end
                         else {if IDent = 'VARCHAR' then}
                         begin
                              {----- VARCHAR ------}
                              if FChar[ichar].FlAddParm in [0,2,3] then
                              begin
                                  if FChar[ichar].FlAddParm = 0
                                     then FChar[ichar].FlAddParm:=2;
                                  if NBuf > 0 then
                                  begin
                                       ErrorLog('*** Error : CHARACTER/VARCHAR with string parameter');
                                       LogReadState; FlagError:=true;
                                  end;

                                  while (icn > 1) do
                                  begin
                                       RState:=NoCommRead(IDent,NBuf,Buf);
                                       case RState of
                                       OpenBrace : begin
                                                 icn:=icn+1;
                                                 ErrorLog('*** Error : CHARACTER/VARCHAR cannot have list parameters');
                                                 ErrorLog('            with sub-lists. Parameter '+IDent+' is ignored');
                                                 LogReadState; FlagError:=true;
                                       end;
                                       CloseBrace : begin
                                       if icn = 2 then
                                       begin
                                            if IDent = 'TOP' then
                                            begin
                                                 if RState <> CloseBrace
                                                    then FileFix11('FONTDIMEN/'+IDent);
                                                 sbuf:=PackBuf(NBuf,Buf);
                                                 FChar[ichar].Top:=ConvFromByte(sbuf,true);
                                            end
                                            else if IDent = 'MID' then
                                            begin
                                                 if RState <> CloseBrace
                                                    then FileFix11('FONTDIMEN/'+IDent);
                                                 sbuf:=PackBuf(NBuf,Buf);
                                                 FChar[ichar].Mid:=ConvFromByte(sbuf,true);
                                            end
                                            else if IDent = 'BOT' then
                                            begin
                                                 if RState <> CloseBrace
                                                    then FileFix11('FONTDIMEN/'+IDent);
                                                 sbuf:=PackBuf(NBuf,Buf);
                                                 FChar[ichar].Bot:=ConvFromByte(sbuf,true);
                                            end
                                            else if IDent = 'REP' then
                                            begin
                                                 if RState <> CloseBrace
                                                    then FileFix11('FONTDIMEN/'+IDent);
                                                 sbuf:=PackBuf(NBuf,Buf);
                                                 FChar[ichar].Rep:=ConvFromByte(sbuf,true);
                                                 FChar[ichar].FlAddParm:=3;
                                            end
                                            else begin
                                                 ErrorLog('*** Error : Unknown FONTDIMEN sub-operator is ignored :'+Ident);
                                                 LogReadState; FlagError:=true;
                                            end;
                                       end;
                                       end;
                                       CloseLex   : begin
                                                  icn:=icn-1;
                                       end;
                                       EndFile    : begin
                                                  ErrorLog('*** Error : Unfinished operator (end-of-file)');
                                                  icn:=0; FlagError:=true;
                                       end;
                                       end; {case}
                                  end; {while}
                                  {--------- end VARCHAR --------------------}
                              end
                              else begin
                                   ErrorLog('*** Error : VARCHAR operator conflicts with the previously defined NEXTLARGER');
                                   LogReadState;
                                   SkipOp(RState,Buf);
                                   FlagError:=true;
                              end;
                         end;
                     end;
                     CloseBrace : begin
                         if icn = 1 then
                         begin
                              if IDent = 'CHARWD' then
                              begin
                                  if RState <> CloseBrace
                                     then FileFix11('CHARACTER/'+IDent);
                                  sbuf:=PackBuf(NBuf,Buf);
                                  FChar[ichar].CharWD:=ConvFromReal(sbuf,true);
                              end
                              else if IDent = 'CHARHT' then
                              begin
                                  if RState <> CloseBrace
                                     then FileFix11('CHARACTER/'+IDent);
                                  sbuf:=PackBuf(NBuf,Buf);
                                  FChar[ichar].CharHT:=ConvFromReal(sbuf,true);
                              end
                              else if IDent = 'CHARDP' then
                              begin
                                  if RState <> CloseBrace
                                     then FileFix11('CHARACTER/'+IDent);
                                  sbuf:=PackBuf(NBuf,Buf);
                                  FChar[ichar].CharDP:=ConvFromReal(sbuf,true);
                              end
                              else if IDent = 'CHARIC' then
                              begin
                                  if RState <> CloseBrace
                                     then FileFix11('CHARACTER/'+IDent);
                                  sbuf:=PackBuf(NBuf,Buf);
                                  FChar[ichar].CharIC:=ConvFromReal(sbuf,true);
                              end
                              else if IDent = 'NEXTLARGER' then
                              begin
                                  if RState <> CloseBrace
                                     then FileFix11('CHARACTER/'+IDent);
                                  if FChar[ichar].FlAddParm in [0,1] then
                                  begin
                                      sbuf:=PackBuf(NBuf,Buf);
                                      FChar[ichar].NextLarger:=ConvFromByte(sbuf,true);
                                      FChar[ichar].FlAddParm:=1;
                                  end
                                  else begin
                                       ErrorLog('*** Error : NEXTLARGER operator conflicts'
                                            +' with the previously defined VARCHAR');
                                      LogReadState; FlagError:=true;
                                  end;
                              end
                              else if IDent = 'VARCHAR' then
                              begin
                                  if FChar[ichar].FlAddParm in [0,2,3] then
                                  begin
                                      if FChar[ichar].FlAddParm = 0
                                         then FChar[ichar].FlAddParm:=2;
                                      {--------- VARCHAR --------------------}
                                      if NBuf > 0 then
                                      begin
                                           ErrorLog('*** Error : CHARACTER/VARCHAR with string parameter');
                                           LogReadState; FlagError:=true;
                                      end;
                                      ErrorLog('*** Warning : CHARACTER/VARCHAR without list parameters');
                                      LogReadState;
                                  end
                                  else begin
                                      ErrorLog('*** Error : VARCHAR operator conflicts'
                                                +' with the previously defined NEXTLARGER');
                                      LogReadState; FlagError:=true;
                                  end;
                              end
                              else begin
                                   ErrorLog('*** Error : Unknown CHARACTER sub-operator is ignored :'+Ident);
                                   LogReadState; FlagError:=true;
                              end;
                         end;
                     end;
                     CloseLex   : begin
                         icn:=icn-1;
                     end;
                     EndFile    : begin
                         ErrorLog('*** Error : Unfinished operator (end-of-file)');
                         icn:=0; FlagError:=true;
                     end;
                     end; {case}
                end; {while}
            {--------- end CHARACTER --------------------}
            end
            else begin
                ErrorLog('*** Error : Unknown operator is ignored :'+Ident);
                LogReadState;
                SkipOp(RState,Buf);
                FlagError:=true;
            end;

         end;
         CloseLex : begin
            ErrorLog('*** Error : Illegal ")" is ignored');
            LogReadState; FlagError:=true;
         end;
         EndFile : begin
            if (Ident <> '') or (NBuf > 0) then
            begin
                 ErrorLog('*** Error : Unfinished operator (end-of-file)');
                 FlagError:=true;
            end;
         end;
         end; {case}
    end; {while}

end; {LoadFontFile}

